package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 个性化推荐
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_personalized_recommendation")
public class PersonalizedRecommendation {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 个性化用户id
     */
    private String personalizedId;
    /**
     * 个性化用户姓名
     */
    private String personalizedName;
    /**
     * 用户类型:0农户 1市场主体
     */
    private Integer userType;
    /**
     * 个性化用户电话
     */
    private String personalizedTelephone;
    /**
     * 是否删除  1已-删除  0-未删除
     */
    private Integer personalizedDelete;
    /**
     * 保险产品id
     */
    private String insuranceProductId;

    public PersonalizedRecommendation(PersonalizedRecommendation personalizedRecommendation) {
        if (Objects.nonNull(personalizedRecommendation)) {
            this.id = personalizedRecommendation.id;
            this.sysId = personalizedRecommendation.sysId;
            this.organizationId = personalizedRecommendation.organizationId;
            this.createTime = personalizedRecommendation.createTime;
            this.updateTime = personalizedRecommendation.updateTime;
            this.personalizedId = personalizedRecommendation.personalizedId;
            this.personalizedName = personalizedRecommendation.personalizedName;
            this.userType = personalizedRecommendation.userType;
            this.personalizedTelephone = personalizedRecommendation.personalizedTelephone;
            this.personalizedDelete = personalizedRecommendation.personalizedDelete;
            this.insuranceProductId = personalizedRecommendation.insuranceProductId;
        }
    }
}
