package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

/**
 * 采购单详情
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_purchase_bill_detail")
public class PurchaseBillDetail {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 采购单单号
     */
    private String purchaseBillCode;
    /**
     * 销售果园Id
     */
    private String saleOrchardId;
    /**
     * 种植品种类型
     */
    private Integer plantType;
    /**
     * 商品类型 1成果 2 种苗
     */
    private Integer productType;
    /**
     * 价格
     */
    private BigDecimal price;
    /**
     * 预期供货 数量(重量)
     */
    private BigDecimal expectQuantity;
    /**
     * 实际供货 数量(重量)
     */
    private BigDecimal realQuantity;
    /**
     * 可供应量
     */
    private BigDecimal remain;
    /**
     * 最小供应量
     */
    private BigDecimal minimumSupply;
    /**
     * 备注
     */
    private String remark;
    /**
     * 可供货时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate supplyDate;
    /**
     * 图片
     */
    private String image;
    /**
     * 种植品种名称
     */
    private String plantTypeName;

    public PurchaseBillDetail(PurchaseBillDetail purchaseBillDetail) {
        if (Objects.nonNull(purchaseBillDetail)) {
            this.id = purchaseBillDetail.id;
            this.purchaseBillCode = purchaseBillDetail.purchaseBillCode;
            this.saleOrchardId = purchaseBillDetail.saleOrchardId;
            this.plantType = purchaseBillDetail.plantType;
            this.productType = purchaseBillDetail.productType;
            this.price = purchaseBillDetail.price;
            this.expectQuantity = purchaseBillDetail.expectQuantity;
            this.realQuantity = purchaseBillDetail.realQuantity;
            this.remain = purchaseBillDetail.remain;
            this.minimumSupply = purchaseBillDetail.minimumSupply;
            this.remark = purchaseBillDetail.remark;
            this.supplyDate = purchaseBillDetail.supplyDate;
            this.image = purchaseBillDetail.image;
            this.plantTypeName = purchaseBillDetail.plantTypeName;
        }
    }
}
