package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * QA知识库
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_qa_knowledge_base")
public class QaKnowledgeBase {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 知识库id
     */
    private String knowledgeBaseId;
    /**
     * Q&A标题
     */
    private String qaTitle;
    /**
     * 状态：0启用 1禁用
     */
    private Integer qaState;
    /**
     * 置顶：0不置顶1置顶
     */
    private Integer qaTop;
    /**
     * 匹配关键字
     */
    private String mappingKeyword;
    /**
     * 回答
     */
    private String qaAnswer;
    /**
     * 分类id
     */
    private String protectClassifyId;
    /**
     * 阅读数量
     */
    private Integer readingNumber;
    /**
     * 是否删除  true已-删除  false-未删除
     */
    private Boolean knowledgeDelete;

    public QaKnowledgeBase(QaKnowledgeBase qaKnowledgeBase) {
        if (Objects.nonNull(qaKnowledgeBase)) {
            this.id = qaKnowledgeBase.id;
            this.sysId = qaKnowledgeBase.sysId;
            this.organizationId = qaKnowledgeBase.organizationId;
            this.createTime = qaKnowledgeBase.createTime;
            this.updateTime = qaKnowledgeBase.updateTime;
            this.knowledgeBaseId = qaKnowledgeBase.knowledgeBaseId;
            this.qaTitle = qaKnowledgeBase.qaTitle;
            this.qaState = qaKnowledgeBase.qaState;
            this.qaTop = qaKnowledgeBase.qaTop;
            this.mappingKeyword = qaKnowledgeBase.mappingKeyword;
            this.qaAnswer = qaKnowledgeBase.qaAnswer;
            this.protectClassifyId = qaKnowledgeBase.protectClassifyId;
            this.readingNumber = qaKnowledgeBase.readingNumber;
            this.knowledgeDelete = qaKnowledgeBase.knowledgeDelete;
        }
    }
}
