package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 服务需求表
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_service_demand")
public class ServiceDemand {
    private static final long serialVersionUID = 1L;
    /**
     * Id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 服务需求Id
     */
    private String serviceDemandId;
    /**
     * 需求方（发布人）ID
     */
    private String publisherId;
    /**
     * 市场主体ID
     */
    private String marketEntityId;
    /**
     * 需求方（发布人）
     */
    private String publisherName;
    /**
     * 需求标题
     */
    private String title;
    /**
     * 内容
     */
    private String content;
    /**
     * 需求状态 1:待确认 2:已接受 3:已拒绝4:已完成 5:已取消
     */
    private Integer serviceDemandStatus;
    /**
     * 最终处理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finalHandleTime;
    /**
     * 审核备注
     */
    private String remark;
    /**
     * 完成备注
     */
    private String finishRemark;
    /**
     * 删除状态 1:未删除 0:已删除
     */
    private Integer deleteStatus;

    public ServiceDemand(ServiceDemand serviceDemand) {
        if (Objects.nonNull(serviceDemand)) {
            this.id = serviceDemand.id;
            this.sysId = serviceDemand.sysId;
            this.organizationId = serviceDemand.organizationId;
            this.createTime = serviceDemand.createTime;
            this.updateTime = serviceDemand.updateTime;
            this.serviceDemandId = serviceDemand.serviceDemandId;
            this.publisherId = serviceDemand.publisherId;
            this.marketEntityId = serviceDemand.marketEntityId;
            this.publisherName = serviceDemand.publisherName;
            this.title = serviceDemand.title;
            this.content = serviceDemand.content;
            this.serviceDemandStatus = serviceDemand.serviceDemandStatus;
            this.finalHandleTime = serviceDemand.finalHandleTime;
            this.remark = serviceDemand.remark;
            this.finishRemark = serviceDemand.finishRemark;
            this.deleteStatus = serviceDemand.deleteStatus;
        }
    }
}
