package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Objects;

/**
 * 自定义标签申领表
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_tag_diy_record")
public class TagDiyRecord {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 标识申领表主键
     */
    private Long recordId;
    /**
     * 规格名称
     */
    private String specificationName;
    /**
     * 领取数量
     */
    private Long amount;
    /**
     * 规格
     */
    private Long specification;
    /**
     * 领取名称
     */
    private String receiveName;
    /**
     * 根据user_type表示不同主体id：type1时为农户id、type2时为企业id、type3时为经销商id
     */
    private String subjectId;

    public TagDiyRecord(TagDiyRecord tagDiyRecord) {
        if (Objects.nonNull(tagDiyRecord)) {
            this.id = tagDiyRecord.id;
            this.recordId = tagDiyRecord.recordId;
            this.specificationName = tagDiyRecord.specificationName;
            this.amount = tagDiyRecord.amount;
            this.specification = tagDiyRecord.specification;
            this.receiveName = tagDiyRecord.receiveName;
            this.subjectId = tagDiyRecord.subjectId;
        }
    }
}
