package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.ContracfillCallback;
import com.panda.zgqc.app.service.IContracfillCallbackService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/contracfill/callback")
public class ContracfillCallbackController {
    @Autowired
    private IContracfillCallbackService contracfillCallbackService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, ContracfillCallback contracfillCallback) {
        return AjaxResult.success(contracfillCallbackService.page(pageEntity.toPage(), Wrappers.lambdaQuery(contracfillCallback)));
    }

    @GetMapping("/list")
    public AjaxResult list(ContracfillCallback contracfillCallback) {
        return AjaxResult.success(contracfillCallbackService.list(Wrappers.lambdaQuery(contracfillCallback)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody ContracfillCallback contracfillCallback) {
        return AjaxResult.success(contracfillCallbackService.save(contracfillCallback));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody ContracfillCallback contracfillCallback) {
        return AjaxResult.success(contracfillCallbackService.updateById(contracfillCallback));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(contracfillCallbackService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(contracfillCallbackService.getById(id));
    }
}
