package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.DiseasePespreventionMethod;
import com.panda.zgqc.app.service.IDiseasePespreventionMethodService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/disease/pesprevention/method")
public class DiseasePespreventionMethodController {
    @Autowired
    private IDiseasePespreventionMethodService diseasePespreventionMethodService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, DiseasePespreventionMethod diseasePespreventionMethod) {
        return AjaxResult.success(diseasePespreventionMethodService.page(pageEntity.toPage(), Wrappers.lambdaQuery(diseasePespreventionMethod)));
    }

    @GetMapping("/list")
    public AjaxResult list(DiseasePespreventionMethod diseasePespreventionMethod) {
        return AjaxResult.success(diseasePespreventionMethodService.list(Wrappers.lambdaQuery(diseasePespreventionMethod)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody DiseasePespreventionMethod diseasePespreventionMethod) {
        return AjaxResult.success(diseasePespreventionMethodService.save(diseasePespreventionMethod));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody DiseasePespreventionMethod diseasePespreventionMethod) {
        return AjaxResult.success(diseasePespreventionMethodService.updateById(diseasePespreventionMethod));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(diseasePespreventionMethodService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(diseasePespreventionMethodService.getById(id));
    }
}
