package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Evaluation;
import com.panda.zgqc.app.service.IEvaluationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/evaluation")
public class EvaluationController {
    @Autowired
    private IEvaluationService evaluationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Evaluation evaluation) {
        return AjaxResult.success(evaluationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(evaluation)));
    }

    @GetMapping("/list")
    public AjaxResult list(Evaluation evaluation) {
        return AjaxResult.success(evaluationService.list(Wrappers.lambdaQuery(evaluation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Evaluation evaluation) {
        return AjaxResult.success(evaluationService.save(evaluation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Evaluation evaluation) {
        return AjaxResult.success(evaluationService.updateById(evaluation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(evaluationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(evaluationService.getById(id));
    }
}
