package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.FinancialSupermarket;
import com.panda.zgqc.app.service.IFinancialSupermarketService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/financial/supermarket")
public class FinancialSupermarketController {
    @Autowired
    private IFinancialSupermarketService financialSupermarketService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, FinancialSupermarket financialSupermarket) {
        return AjaxResult.success(financialSupermarketService.page(pageEntity.toPage(), Wrappers.lambdaQuery(financialSupermarket)));
    }

    @GetMapping("/list")
    public AjaxResult list(FinancialSupermarket financialSupermarket) {
        return AjaxResult.success(financialSupermarketService.list(Wrappers.lambdaQuery(financialSupermarket)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody FinancialSupermarket financialSupermarket) {
        return AjaxResult.success(financialSupermarketService.save(financialSupermarket));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody FinancialSupermarket financialSupermarket) {
        return AjaxResult.success(financialSupermarketService.updateById(financialSupermarket));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(financialSupermarketService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(financialSupermarketService.getById(id));
    }
}
