package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.OtherRelatedSubjecinformation;
import com.panda.zgqc.app.service.IOtherRelatedSubjecinformationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/other/related/subjecinformation")
public class OtherRelatedSubjecinformationController {
    @Autowired
    private IOtherRelatedSubjecinformationService otherRelatedSubjecinformationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, OtherRelatedSubjecinformation otherRelatedSubjecinformation) {
        return AjaxResult.success(otherRelatedSubjecinformationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(otherRelatedSubjecinformation)));
    }

    @GetMapping("/list")
    public AjaxResult list(OtherRelatedSubjecinformation otherRelatedSubjecinformation) {
        return AjaxResult.success(otherRelatedSubjecinformationService.list(Wrappers.lambdaQuery(otherRelatedSubjecinformation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody OtherRelatedSubjecinformation otherRelatedSubjecinformation) {
        return AjaxResult.success(otherRelatedSubjecinformationService.save(otherRelatedSubjecinformation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody OtherRelatedSubjecinformation otherRelatedSubjecinformation) {
        return AjaxResult.success(otherRelatedSubjecinformationService.updateById(otherRelatedSubjecinformation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(otherRelatedSubjecinformationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(otherRelatedSubjecinformationService.getById(id));
    }
}
