package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.PurchaseBillDetail;
import com.panda.zgqc.app.service.IPurchaseBillDetailService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/purchase/bill/detail")
public class PurchaseBillDetailController {
    @Autowired
    private IPurchaseBillDetailService purchaseBillDetailService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, PurchaseBillDetail purchaseBillDetail) {
        return AjaxResult.success(purchaseBillDetailService.page(pageEntity.toPage(), Wrappers.lambdaQuery(purchaseBillDetail)));
    }

    @GetMapping("/list")
    public AjaxResult list(PurchaseBillDetail purchaseBillDetail) {
        return AjaxResult.success(purchaseBillDetailService.list(Wrappers.lambdaQuery(purchaseBillDetail)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody PurchaseBillDetail purchaseBillDetail) {
        return AjaxResult.success(purchaseBillDetailService.save(purchaseBillDetail));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody PurchaseBillDetail purchaseBillDetail) {
        return AjaxResult.success(purchaseBillDetailService.updateById(purchaseBillDetail));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(purchaseBillDetailService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(purchaseBillDetailService.getById(id));
    }
}
