package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.QaKnowledgeBase;
import com.panda.zgqc.app.service.IQaKnowledgeBaseService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/qa/knowledge/base")
public class QaKnowledgeBaseController {
    @Autowired
    private IQaKnowledgeBaseService qaKnowledgeBaseService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, QaKnowledgeBase qaKnowledgeBase) {
        return AjaxResult.success(qaKnowledgeBaseService.page(pageEntity.toPage(), Wrappers.lambdaQuery(qaKnowledgeBase)));
    }

    @GetMapping("/list")
    public AjaxResult list(QaKnowledgeBase qaKnowledgeBase) {
        return AjaxResult.success(qaKnowledgeBaseService.list(Wrappers.lambdaQuery(qaKnowledgeBase)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody QaKnowledgeBase qaKnowledgeBase) {
        return AjaxResult.success(qaKnowledgeBaseService.save(qaKnowledgeBase));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody QaKnowledgeBase qaKnowledgeBase) {
        return AjaxResult.success(qaKnowledgeBaseService.updateById(qaKnowledgeBase));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(qaKnowledgeBaseService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(qaKnowledgeBaseService.getById(id));
    }
}
