package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.SaleOrchard;
import com.panda.zgqc.app.service.ISaleOrchardService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/sale/orchard")
public class SaleOrchardController {
    @Autowired
    private ISaleOrchardService saleOrchardService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, SaleOrchard saleOrchard) {
        return AjaxResult.success(saleOrchardService.page(pageEntity.toPage(), Wrappers.lambdaQuery(saleOrchard)));
    }

    @GetMapping("/list")
    public AjaxResult list(SaleOrchard saleOrchard) {
        return AjaxResult.success(saleOrchardService.list(Wrappers.lambdaQuery(saleOrchard)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody SaleOrchard saleOrchard) {
        return AjaxResult.success(saleOrchardService.save(saleOrchard));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SaleOrchard saleOrchard) {
        return AjaxResult.success(saleOrchardService.updateById(saleOrchard));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(saleOrchardService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(saleOrchardService.getById(id));
    }
}
