package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Specification;
import com.panda.zgqc.app.service.ISpecificationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/specification")
public class SpecificationController {
    @Autowired
    private ISpecificationService specificationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Specification specification) {
        return AjaxResult.success(specificationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(specification)));
    }

    @GetMapping("/list")
    public AjaxResult list(Specification specification) {
        return AjaxResult.success(specificationService.list(Wrappers.lambdaQuery(specification)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Specification specification) {
        return AjaxResult.success(specificationService.save(specification));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Specification specification) {
        return AjaxResult.success(specificationService.updateById(specification));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(specificationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(specificationService.getById(id));
    }
}
