package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.TagDiyRecord;
import com.panda.zgqc.app.service.ITagDiyRecordService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/tag/diy/record")
public class TagDiyRecordController {
    @Autowired
    private ITagDiyRecordService tagDiyRecordService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, TagDiyRecord tagDiyRecord) {
        return AjaxResult.success(tagDiyRecordService.page(pageEntity.toPage(), Wrappers.lambdaQuery(tagDiyRecord)));
    }

    @GetMapping("/list")
    public AjaxResult list(TagDiyRecord tagDiyRecord) {
        return AjaxResult.success(tagDiyRecordService.list(Wrappers.lambdaQuery(tagDiyRecord)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody TagDiyRecord tagDiyRecord) {
        return AjaxResult.success(tagDiyRecordService.save(tagDiyRecord));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody TagDiyRecord tagDiyRecord) {
        return AjaxResult.success(tagDiyRecordService.updateById(tagDiyRecord));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(tagDiyRecordService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(tagDiyRecordService.getById(id));
    }
}
