package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 病虫害-关联记录
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_disease_pest_store_relation")
public class DiseasePesstoreRelation {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 部门id
     */
    private String deptId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 病虫害主键关联
     */
    private Long diseaseStoreId;
    /**
     * 0为防治，1为宿主
     */
    private Integer state;
    /**
     * 4-7 11-14 防治措施
     */
    private String pdTypeId;
    /**
     * 具体内容：state为0：防治内容 1：宿主
     */
    private String value;

    public DiseasePesstoreRelation(DiseasePesstoreRelation diseasePesstoreRelation) {
        if (Objects.nonNull(diseasePesstoreRelation)) {
            this.id = diseasePesstoreRelation.id;
            this.sysId = diseasePesstoreRelation.sysId;
            this.organizationId = diseasePesstoreRelation.organizationId;
            this.deptId = diseasePesstoreRelation.deptId;
            this.operator = diseasePesstoreRelation.operator;
            this.operatorName = diseasePesstoreRelation.operatorName;
            this.createTime = diseasePesstoreRelation.createTime;
            this.updateTime = diseasePesstoreRelation.updateTime;
            this.diseaseStoreId = diseasePesstoreRelation.diseaseStoreId;
            this.state = diseasePesstoreRelation.state;
            this.pdTypeId = diseasePesstoreRelation.pdTypeId;
            this.value = diseasePesstoreRelation.value;
        }
    }
}
