package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Objects;

/**
 * 虫害和鼠害设备数据
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_insect_device")
public class Insecdevice {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    private String deviceId;
    private String deviceName;
    private String deviceType;
    private String address;
    private String latitude;
    private String longitude;
    /**
     * 1-拓普云农 2-北京依科曼
     */
    private Integer source;
    /**
     * 1:在线 0:离线
     */
    private Integer status;
    /**
     * 1-虫情  2-鼠害
     */
    private Integer deviceFlag;

    public Insecdevice(Insecdevice insecdevice) {
        if (Objects.nonNull(insecdevice)) {
            this.id = insecdevice.id;
            this.deviceId = insecdevice.deviceId;
            this.deviceName = insecdevice.deviceName;
            this.deviceType = insecdevice.deviceType;
            this.address = insecdevice.address;
            this.latitude = insecdevice.latitude;
            this.longitude = insecdevice.longitude;
            this.source = insecdevice.source;
            this.status = insecdevice.status;
            this.deviceFlag = insecdevice.deviceFlag;
        }
    }
}
