package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 虫害监测数据
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_insect_monitor_data")
public class InsecmonitorData {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    private String deviceId;
    private String deviceName;
    private String insectType;
    private Integer insectCount;
    private String temperature;
    private String humidity;
    private String image;
    private Integer source;

    public InsecmonitorData(InsecmonitorData insecmonitorData) {
        if (Objects.nonNull(insecmonitorData)) {
            this.id = insecmonitorData.id;
            this.createTime = insecmonitorData.createTime;
            this.deviceId = insecmonitorData.deviceId;
            this.deviceName = insecmonitorData.deviceName;
            this.insectType = insecmonitorData.insectType;
            this.insectCount = insecmonitorData.insectCount;
            this.temperature = insecmonitorData.temperature;
            this.humidity = insecmonitorData.humidity;
            this.image = insecmonitorData.image;
            this.source = insecmonitorData.source;
        }
    }
}
