package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 物联网预警
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_iot_warning")
public class Iowarning {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 预警内容
     */
    private String content;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 地块名称
     */
    private String fieldName;
    /**
     * 设备类型
     */
    private String type;
    /**
     * 属性名
     */
    private String property;
    /**
     * 数值
     */
    private String data;
    /**
     * 范围
     */
    private String dataRange;
    /**
     * 数值单位
     */
    private String dataUnit;
    /**
     * 预警来源 0-传感器  1-气象
     */
    private Integer source;

    public Iowarning(Iowarning iowarning) {
        if (Objects.nonNull(iowarning)) {
            this.id = iowarning.id;
            this.content = iowarning.content;
            this.createTime = iowarning.createTime;
            this.updateTime = iowarning.updateTime;
            this.fieldName = iowarning.fieldName;
            this.type = iowarning.type;
            this.property = iowarning.property;
            this.data = iowarning.data;
            this.dataRange = iowarning.dataRange;
            this.dataUnit = iowarning.dataUnit;
            this.source = iowarning.source;
        }
    }
}
