package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 市场主体详情
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_market_entity_detail")
public class MarkeentityDetail {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 服务标签   1:洗果  2:运果  3:采果  4:生产  5:施肥   6:其他
     */
    private String serviceTag;
    /**
     * 缩略图
     */
    private String thumbnail;
    /**
     * 图文
     */
    private String teletext;

    public MarkeentityDetail(MarkeentityDetail markeentityDetail) {
        if (Objects.nonNull(markeentityDetail)) {
            this.id = markeentityDetail.id;
            this.sysId = markeentityDetail.sysId;
            this.organizationId = markeentityDetail.organizationId;
            this.operator = markeentityDetail.operator;
            this.createTime = markeentityDetail.createTime;
            this.updateTime = markeentityDetail.updateTime;
            this.operatorName = markeentityDetail.operatorName;
            this.serviceTag = markeentityDetail.serviceTag;
            this.thumbnail = markeentityDetail.thumbnail;
            this.teletext = markeentityDetail.teletext;
        }
    }
}
