package com.panda.zgqc.app.controller;


import com.panda.zgqc.app.domain.Agent;
import com.panda.zgqc.app.service.IAgentService;
import com.panda.common.entity.AjaxResult;

import lombok.extern.log4j.Log4j2;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Collections;


import static com.baomidou.mybatisplus.core.toolkit.Wrappers.lambdaQuery;

@RestController
@RequestMapping("/app/agent")
@Log4j2
public class AgentController {
    @Resource
    private IAgentService agentService;



    @GetMapping("/list")
    public AjaxResult list(Agent agent) {
        return AjaxResult.success(agentService.list(lambdaQuery(agent)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Agent agent) {
        return AjaxResult.success(agentService.save(agent));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Agent agent) {
        return AjaxResult.success(agentService.updateById(agent));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(agentService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(agentService.getById(id));
    }
}
