package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.AgriculturalTechnologyCourse;
import com.panda.zgqc.app.service.IAgriculturalTechnologyCourseService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/agricultural/technology/course")
public class AgriculturalTechnologyCourseController {
    @Autowired
    private IAgriculturalTechnologyCourseService agriculturalTechnologyCourseService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, AgriculturalTechnologyCourse agriculturalTechnologyCourse) {
        return AjaxResult.success(agriculturalTechnologyCourseService.page(pageEntity.toPage(), Wrappers.lambdaQuery(agriculturalTechnologyCourse)));
    }

    @GetMapping("/list")
    public AjaxResult list(AgriculturalTechnologyCourse agriculturalTechnologyCourse) {
        return AjaxResult.success(agriculturalTechnologyCourseService.list(Wrappers.lambdaQuery(agriculturalTechnologyCourse)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody AgriculturalTechnologyCourse agriculturalTechnologyCourse) {
        return AjaxResult.success(agriculturalTechnologyCourseService.save(agriculturalTechnologyCourse));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody AgriculturalTechnologyCourse agriculturalTechnologyCourse) {
        return AjaxResult.success(agriculturalTechnologyCourseService.updateById(agriculturalTechnologyCourse));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(agriculturalTechnologyCourseService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(agriculturalTechnologyCourseService.getById(id));
    }
}
