package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Contracfinish;
import com.panda.zgqc.app.service.IContracfinishService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/contracfinish")
public class ContracfinishController {
    @Autowired
    private IContracfinishService contracfinishService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Contracfinish contracfinish) {
        return AjaxResult.success(contracfinishService.page(pageEntity.toPage(), Wrappers.lambdaQuery(contracfinish)));
    }

    @GetMapping("/list")
    public AjaxResult list(Contracfinish contracfinish) {
        return AjaxResult.success(contracfinishService.list(Wrappers.lambdaQuery(contracfinish)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Contracfinish contracfinish) {
        return AjaxResult.success(contracfinishService.save(contracfinish));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Contracfinish contracfinish) {
        return AjaxResult.success(contracfinishService.updateById(contracfinish));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(contracfinishService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(contracfinishService.getById(id));
    }
}
