package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.ContracsignCallback;
import com.panda.zgqc.app.service.IContracsignCallbackService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/contracsign/callback")
public class ContracsignCallbackController {
    @Autowired
    private IContracsignCallbackService contracsignCallbackService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, ContracsignCallback contracsignCallback) {
        return AjaxResult.success(contracsignCallbackService.page(pageEntity.toPage(), Wrappers.lambdaQuery(contracsignCallback)));
    }

    @GetMapping("/list")
    public AjaxResult list(ContracsignCallback contracsignCallback) {
        return AjaxResult.success(contracsignCallbackService.list(Wrappers.lambdaQuery(contracsignCallback)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody ContracsignCallback contracsignCallback) {
        return AjaxResult.success(contracsignCallbackService.save(contracsignCallback));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody ContracsignCallback contracsignCallback) {
        return AjaxResult.success(contracsignCallbackService.updateById(contracsignCallback));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(contracsignCallbackService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(contracsignCallbackService.getById(id));
    }
}
