package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Declare;
import com.panda.zgqc.app.service.IDeclareService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/declare")
public class DeclareController {
    @Autowired
    private IDeclareService declareService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Declare declare) {
        return AjaxResult.success(declareService.page(pageEntity.toPage(), Wrappers.lambdaQuery(declare)));
    }

    @GetMapping("/list")
    public AjaxResult list(Declare declare) {
        return AjaxResult.success(declareService.list(Wrappers.lambdaQuery(declare)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Declare declare) {
        return AjaxResult.success(declareService.save(declare));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Declare declare) {
        return AjaxResult.success(declareService.updateById(declare));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Integer[] ids) {
        return AjaxResult.success(declareService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Integer id) {
        return AjaxResult.success(declareService.getById(id));
    }
}
