package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.MeteorologyWarningRule;
import com.panda.zgqc.app.service.IMeteorologyWarningRuleService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/meteorology/warning/rule")
public class MeteorologyWarningRuleController {
    @Autowired
    private IMeteorologyWarningRuleService meteorologyWarningRuleService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, MeteorologyWarningRule meteorologyWarningRule) {
        return AjaxResult.success(meteorologyWarningRuleService.page(pageEntity.toPage(), Wrappers.lambdaQuery(meteorologyWarningRule)));
    }

    @GetMapping("/list")
    public AjaxResult list(MeteorologyWarningRule meteorologyWarningRule) {
        return AjaxResult.success(meteorologyWarningRuleService.list(Wrappers.lambdaQuery(meteorologyWarningRule)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody MeteorologyWarningRule meteorologyWarningRule) {
        return AjaxResult.success(meteorologyWarningRuleService.save(meteorologyWarningRule));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody MeteorologyWarningRule meteorologyWarningRule) {
        return AjaxResult.success(meteorologyWarningRuleService.updateById(meteorologyWarningRule));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(meteorologyWarningRuleService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(meteorologyWarningRuleService.getById(id));
    }
}
