package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.SaleOrchardDetail;
import com.panda.zgqc.app.service.ISaleOrchardDetailService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/sale/orchard/detail")
public class SaleOrchardDetailController {
    @Autowired
    private ISaleOrchardDetailService saleOrchardDetailService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, SaleOrchardDetail saleOrchardDetail) {
        return AjaxResult.success(saleOrchardDetailService.page(pageEntity.toPage(), Wrappers.lambdaQuery(saleOrchardDetail)));
    }

    @GetMapping("/list")
    public AjaxResult list(SaleOrchardDetail saleOrchardDetail) {
        return AjaxResult.success(saleOrchardDetailService.list(Wrappers.lambdaQuery(saleOrchardDetail)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody SaleOrchardDetail saleOrchardDetail) {
        return AjaxResult.success(saleOrchardDetailService.save(saleOrchardDetail));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SaleOrchardDetail saleOrchardDetail) {
        return AjaxResult.success(saleOrchardDetailService.updateById(saleOrchardDetail));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(saleOrchardDetailService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(saleOrchardDetailService.getById(id));
    }
}
