package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.SaleOrchardSnapshot;
import com.panda.zgqc.app.service.ISaleOrchardSnapshotService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/sale/orchard/snapshot")
public class SaleOrchardSnapshotController {
    @Autowired
    private ISaleOrchardSnapshotService saleOrchardSnapshotService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, SaleOrchardSnapshot saleOrchardSnapshot) {
        return AjaxResult.success(saleOrchardSnapshotService.page(pageEntity.toPage(), Wrappers.lambdaQuery(saleOrchardSnapshot)));
    }

    @GetMapping("/list")
    public AjaxResult list(SaleOrchardSnapshot saleOrchardSnapshot) {
        return AjaxResult.success(saleOrchardSnapshotService.list(Wrappers.lambdaQuery(saleOrchardSnapshot)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody SaleOrchardSnapshot saleOrchardSnapshot) {
        return AjaxResult.success(saleOrchardSnapshotService.save(saleOrchardSnapshot));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SaleOrchardSnapshot saleOrchardSnapshot) {
        return AjaxResult.success(saleOrchardSnapshotService.updateById(saleOrchardSnapshot));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(saleOrchardSnapshotService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(saleOrchardSnapshotService.getById(id));
    }
}
