package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 经纪人农户关联
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_agent_farmer_relevance")
public class AgentFarmerRelevance {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 经纪人id
     */
    private String agentManagementId;
    /**
     * 经纪人姓名
     */
    private String agentName;
    /**
     * 农户id
     */
    private String farmerId;
    /**
     * 农户姓名
     */
    private String farmerName;
    /**
     * 状态:0未绑定 1绑定
     */
    private Integer relevanceState;

    public AgentFarmerRelevance(AgentFarmerRelevance AgentFarmerRelevance) {
        if (Objects.nonNull(AgentFarmerRelevance)) {
            this.id = AgentFarmerRelevance.id;
            this.sysId = AgentFarmerRelevance.sysId;
            this.organizationId = AgentFarmerRelevance.organizationId;
            this.createTime = AgentFarmerRelevance.createTime;
            this.updateTime = AgentFarmerRelevance.updateTime;
            this.agentManagementId = AgentFarmerRelevance.agentManagementId;
            this.agentName = AgentFarmerRelevance.agentName;
            this.farmerId = AgentFarmerRelevance.farmerId;
            this.farmerName = AgentFarmerRelevance.farmerName;
            this.relevanceState = AgentFarmerRelevance.relevanceState;
        }
    }
}
