package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 农技课程
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_agricultural_technology_course")
public class AgriculturalTechnologyCourse {
    private static final long serialVersionUID = 1L;
    /**
     * 自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 课程标题
     */
    private String courseTitle;
    /**
     * 视频地址
     */
    private String videoUrl;
    /**
     * 视频缩略图
     */
    private String thumbnail;
    /**
     * 课程介绍
     */
    private String courseIntroduce;
    /**
     * 专家姓名
     */
    private String expertName;
    /**
     * 专家身份
     */
    private String expertIdentity;
    /**
     * 专家照片
     */
    private String expertImage;
    /**
     * 专家介绍
     */
    private String expertIntroduce;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 学习人数
     */
    private Integer studyNumber;
    /**
     * 是否删除  true已-删除  false-未删除
     */
    private Boolean deleted;

    public AgriculturalTechnologyCourse(AgriculturalTechnologyCourse agriculturalTechnologyCourse) {
        if (Objects.nonNull(agriculturalTechnologyCourse)) {
            this.id = agriculturalTechnologyCourse.id;
            this.courseTitle = agriculturalTechnologyCourse.courseTitle;
            this.videoUrl = agriculturalTechnologyCourse.videoUrl;
            this.thumbnail = agriculturalTechnologyCourse.thumbnail;
            this.courseIntroduce = agriculturalTechnologyCourse.courseIntroduce;
            this.expertName = agriculturalTechnologyCourse.expertName;
            this.expertIdentity = agriculturalTechnologyCourse.expertIdentity;
            this.expertImage = agriculturalTechnologyCourse.expertImage;
            this.expertIntroduce = agriculturalTechnologyCourse.expertIntroduce;
            this.organizationId = agriculturalTechnologyCourse.organizationId;
            this.sysId = agriculturalTechnologyCourse.sysId;
            this.createTime = agriculturalTechnologyCourse.createTime;
            this.updateTime = agriculturalTechnologyCourse.updateTime;
            this.studyNumber = agriculturalTechnologyCourse.studyNumber;
            this.deleted = agriculturalTechnologyCourse.deleted;
        }
    }
}
