package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 品牌信息管理
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_brand_information")
public class BrandInformation {
    private static final long serialVersionUID = 1L;
    /**
     * 表自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 品牌图片
     */
    private String brandImages;
    /**
     * 品牌故事
     */
    private String brandText;
    /**
     * 关联主体
     */
    private String relevantEntity;

    public BrandInformation(BrandInformation brandInformation) {
        if (Objects.nonNull(brandInformation)) {
            this.id = brandInformation.id;
            this.sysId = brandInformation.sysId;
            this.organizationId = brandInformation.organizationId;
            this.operator = brandInformation.operator;
            this.operatorName = brandInformation.operatorName;
            this.createTime = brandInformation.createTime;
            this.updateTime = brandInformation.updateTime;
            this.brandImages = brandInformation.brandImages;
            this.brandText = brandInformation.brandText;
            this.relevantEntity = brandInformation.relevantEntity;
        }
    }
}
