package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 包装申请（品牌服务）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_brand_package_apply")
public class BrandPackageApply {
    private static final long serialVersionUID = 1L;
    /**
     * 自增id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;
    /**
     * 包装申请id
     */
    private String applyId;
    /**
     * 包装申请单号
     */
    private String applyCode;
    /**
     * 类型（0-统一包装 1-个性化包装）
     */
    private Integer applyType;
    /**
     * 状态（0-待审核 -1-已取消 10-已拒绝  20-已通过 30-待提货  40-已完成）
     */
    private Integer status;
    /**
     * 申请人/采购人id
     */
    private String applierId;
    /**
     * 申请人/采购人名字
     */
    private String applierName;
    /**
     * 交货方式
     */
    private String deliveryWay;
    /**
     * 期望交货时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectTime;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/下单时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 提货方式
     */
    private String takeWay;
    /**
     * 审核时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime verifyTime;
    /**
     * 审核人
     */
    private String verifierId;
    /**
     * 审核人名字
     */
    private String verifierName;
    /**
     * 审核备注
     */
    private String verifierRemark;
    /**
     * 审核结果
     */
    private String verifierResult;
    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finishTime;
    /**
     * 包装单备注
     */
    private String remark;

    public BrandPackageApply(BrandPackageApply brandPackageApply) {
        if (Objects.nonNull(brandPackageApply)) {
            this.id = brandPackageApply.id;
            this.applyId = brandPackageApply.applyId;
            this.applyCode = brandPackageApply.applyCode;
            this.applyType = brandPackageApply.applyType;
            this.status = brandPackageApply.status;
            this.applierId = brandPackageApply.applierId;
            this.applierName = brandPackageApply.applierName;
            this.deliveryWay = brandPackageApply.deliveryWay;
            this.expectTime = brandPackageApply.expectTime;
            this.sysId = brandPackageApply.sysId;
            this.organizationId = brandPackageApply.organizationId;
            this.createTime = brandPackageApply.createTime;
            this.updateTime = brandPackageApply.updateTime;
            this.takeWay = brandPackageApply.takeWay;
            this.verifyTime = brandPackageApply.verifyTime;
            this.verifierId = brandPackageApply.verifierId;
            this.verifierName = brandPackageApply.verifierName;
            this.verifierRemark = brandPackageApply.verifierRemark;
            this.verifierResult = brandPackageApply.verifierResult;
            this.finishTime = brandPackageApply.finishTime;
            this.remark = brandPackageApply.remark;
        }
    }
}
