package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 病虫害-识别记录
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_disease_pest_store")
public class DiseasePesstore {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 病虫害编号
     */
    private String diseasePestCode;
    /**
     * 典型图片链接
     */
    private String typicalImg;
    /**
     * 病虫害名称
     */
    private String pdName;
    /**
     * 类型：D 为病害, P 为虫害,N 天敌，G 草害，X 生理性病害
     */
    private String type;
    /**
     * 分类及别名
     */
    private String commonNameSort;
    /**
     * 危害状图片
     */
    private String harmStateImgs;
    /**
     * D-危害特征
     */
    private String harmCharacteristic;
    /**
     * D-发病周期
     */
    private String sickCycle;
    /**
     * 发病条件及传染性
     */
    private String sickInfect;
    /**
     * P-危害作物
     */
    private String dangerCrop;
    /**
     * P-危害虫态及危害状
     */
    private String dangerState;
    /**
     * P-发生规律
     */
    private String appearRule;
    /**
     * N-形态特征
     */
    private String shapeCharacter;
    /**
     * N-防治对象
     */
    private String preventionObject;
    /**
     * G-生活型
     */
    private String lifeType;
    /**
     * G-发生规律
     */
    private String happenRule;
    /**
     * 防除措施
     */
    private String controlMeasure;
    /**
     * X-原因及症状
     */
    private String causeSymptom;
    /**
     * X-防治方法
     */
    private String preventionMethod;

    public DiseasePesstore(DiseasePesstore diseasePesstore) {
        if (Objects.nonNull(diseasePesstore)) {
            this.id = diseasePesstore.id;
            this.sysId = diseasePesstore.sysId;
            this.organizationId = diseasePesstore.organizationId;
            this.operator = diseasePesstore.operator;
            this.operatorName = diseasePesstore.operatorName;
            this.createTime = diseasePesstore.createTime;
            this.updateTime = diseasePesstore.updateTime;
            this.diseasePestCode = diseasePesstore.diseasePestCode;
            this.typicalImg = diseasePesstore.typicalImg;
            this.pdName = diseasePesstore.pdName;
            this.type = diseasePesstore.type;
            this.commonNameSort = diseasePesstore.commonNameSort;
            this.harmStateImgs = diseasePesstore.harmStateImgs;
            this.harmCharacteristic = diseasePesstore.harmCharacteristic;
            this.sickCycle = diseasePesstore.sickCycle;
            this.sickInfect = diseasePesstore.sickInfect;
            this.dangerCrop = diseasePesstore.dangerCrop;
            this.dangerState = diseasePesstore.dangerState;
            this.appearRule = diseasePesstore.appearRule;
            this.shapeCharacter = diseasePesstore.shapeCharacter;
            this.preventionObject = diseasePesstore.preventionObject;
            this.lifeType = diseasePesstore.lifeType;
            this.happenRule = diseasePesstore.happenRule;
            this.controlMeasure = diseasePesstore.controlMeasure;
            this.causeSymptom = diseasePesstore.causeSymptom;
            this.preventionMethod = diseasePesstore.preventionMethod;
        }
    }
}
