package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 金融超市
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_financial_supermarket")
public class FinancialSupermarket {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间/发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 金融超市id
     */
    private String financialSupermarketId;
    /**
     * 金融产品名称
     */
    private String financialProductName;
    /**
     * 缩略图
     */
    private String smallPicture;
    /**
     * 贷款金额（万元）
     */
    private BigDecimal loansMoney;
    /**
     * 状态:默认0启用、1禁用
     */
    private Integer financialStatus;
    /**
     * 备注
     */
    private String financialRemark;
    /**
     * 是否删除  true已-删除  false-未删除
     */
    private Boolean financialDelete;

    public FinancialSupermarket(FinancialSupermarket financialSupermarket) {
        if (Objects.nonNull(financialSupermarket)) {
            this.id = financialSupermarket.id;
            this.sysId = financialSupermarket.sysId;
            this.organizationId = financialSupermarket.organizationId;
            this.createTime = financialSupermarket.createTime;
            this.updateTime = financialSupermarket.updateTime;
            this.financialSupermarketId = financialSupermarket.financialSupermarketId;
            this.financialProductName = financialSupermarket.financialProductName;
            this.smallPicture = financialSupermarket.smallPicture;
            this.loansMoney = financialSupermarket.loansMoney;
            this.financialStatus = financialSupermarket.financialStatus;
            this.financialRemark = financialSupermarket.financialRemark;
            this.financialDelete = financialSupermarket.financialDelete;
        }
    }
}
