package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 市场主体管理
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_market_entity")
public class Markeentity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人id
     */
    private String operator;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 企业id
     */
    private String orgId;
    /**
     * 市场主体名称
     */
    private String entityName;
    /**
     * 所在地
     */
    private String address;
    /**
     * 区域编码
     */
    private String regionCode;
    /**
     * 详细地址
     */
    private String addressDetail;
    /**
     * 社会统一信用代码
     */
    private String socUnifiedCreditCode;
    /**
     * 管理员手机号
     */
    private String managerNumber;
    /**
     * 管理员姓名
     */
    private String managerMan;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态 1启用状态     0禁用状态
     */
    private Integer disableStatus;

    public Markeentity(Markeentity markeentity) {
        if (Objects.nonNull(markeentity)) {
            this.id = markeentity.id;
            this.sysId = markeentity.sysId;
            this.organizationId = markeentity.organizationId;
            this.operator = markeentity.operator;
            this.createTime = markeentity.createTime;
            this.updateTime = markeentity.updateTime;
            this.operatorName = markeentity.operatorName;
            this.orgId = markeentity.orgId;
            this.entityName = markeentity.entityName;
            this.address = markeentity.address;
            this.regionCode = markeentity.regionCode;
            this.addressDetail = markeentity.addressDetail;
            this.socUnifiedCreditCode = markeentity.socUnifiedCreditCode;
            this.managerNumber = markeentity.managerNumber;
            this.managerMan = markeentity.managerMan;
            this.remark = markeentity.remark;
            this.disableStatus = markeentity.disableStatus;
        }
    }
}
