package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 预警规则
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_meteorology_warning_rule")
public class MeteorologyWarningRule {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 预警规则id
     */
    private String ruleId;
    /**
     * 预警类别 1-冷冻害 2-干旱
     */
    private Integer type;
    /**
     * 预警级别
     */
    private Integer level;
    /**
     * 预警作物
     */
    private String farmPlant;
    /**
     * 预警影响
     */
    private String influence;
    /**
     * 级别描述
     */
    private String description;
    /**
     * 防范措施
     */
    private String prevention;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 条件关系 1-或 2-且
     */
    private Integer conditionSymbol;

    public MeteorologyWarningRule(MeteorologyWarningRule meteorologyWarningRule) {
        if (Objects.nonNull(meteorologyWarningRule)) {
            this.id = meteorologyWarningRule.id;
            this.ruleId = meteorologyWarningRule.ruleId;
            this.type = meteorologyWarningRule.type;
            this.level = meteorologyWarningRule.level;
            this.farmPlant = meteorologyWarningRule.farmPlant;
            this.influence = meteorologyWarningRule.influence;
            this.description = meteorologyWarningRule.description;
            this.prevention = meteorologyWarningRule.prevention;
            this.createTime = meteorologyWarningRule.createTime;
            this.updateTime = meteorologyWarningRule.updateTime;
            this.conditionSymbol = meteorologyWarningRule.conditionSymbol;
        }
    }
}
