package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 果园-地块关联表
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_orchard_garden_relation")
public class OrchardGardenRelation {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 托管/销售    果园编号
     */
    private String orchardCode;
    /**
     * 地块编号
     */
    private String gardenCode;
    /**
     * 生效状态 0生效 1失效
     */
    private Integer disableStatus;
    /**
     * 关联类型 1托管果园 2 销售果园
     */
    private Integer relationType;

    public OrchardGardenRelation(OrchardGardenRelation orchardGardenRelation) {
        if (Objects.nonNull(orchardGardenRelation)) {
            this.id = orchardGardenRelation.id;
            this.createTime = orchardGardenRelation.createTime;
            this.updateTime = orchardGardenRelation.updateTime;
            this.orchardCode = orchardGardenRelation.orchardCode;
            this.gardenCode = orchardGardenRelation.gardenCode;
            this.disableStatus = orchardGardenRelation.disableStatus;
            this.relationType = orchardGardenRelation.relationType;
        }
    }
}
