package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 采购单
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_purchase_bill")
public class PurchaseBill {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 采购单单号
     */
    private String purchaseBillCode;
    /**
     * 销售果园Id
     */
    private String saleOrchardId;
    /**
     * 销售果园标题
     */
    private String title;
    /**
     * 果园地址
     */
    private String orchardAddress;
    /**
     * 地址经度
     */
    private BigDecimal longitude;
    /**
     * 地址纬度
     */
    private BigDecimal latitude;
    /**
     * 采购方Id
     */
    private String buyerId;
    /**
     * 采购方姓名
     */
    private String buyerName;
    /**
     * 采购方类型
     */
    private Integer buyerType;
    /**
     * 供货方Id
     */
    private String sellerId;
    /**
     * 供货方姓名
     */
    private String sellerName;
    /**
     * 卖方类型
     */
    private Integer sellerType;
    /**
     * 销售区域
     */
    private String sellerArea;
    /**
     * 销售区域编码
     */
    private String sellerAreaRegion;
    /**
     * 采摘要求
     */
    private String pickRequirement;
    /**
     * 要求供货时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate requireSupplyDate;
    /**
     * 采收时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate pickDate;
    /**
     * 确认时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime ensureDate;
    /**
     * 取消时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime cancelDate;
    /**
     * 拒绝时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime rejectDate;
    /**
     * 拒绝理由
     */
    private String rejectReason;
    /**
     * 定金支付时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime depositDate;
    /**
     * 尾款支付时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime finalPaymentDate;
    /**
     * 总金额
     */
    private BigDecimal amount;
    /**
     * 优惠金额
     */
    private BigDecimal discount;
    /**
     * 定金
     */
    private BigDecimal deposit;
    /**
     * 尾款
     */
    private BigDecimal finalPayment;
    /**
     * 供货方式 默认1 现场交货
     */
    private Integer supplyType;
    /**
     * 订单状态： 1待确认 2待付定金 3 代采收 4 待付尾款 5 已拒绝 6已取消 7 已完成
     */
    private Integer purchaseStatus;

    public PurchaseBill(PurchaseBill purchaseBill) {
        if (Objects.nonNull(purchaseBill)) {
            this.id = purchaseBill.id;
            this.sysId = purchaseBill.sysId;
            this.organizationId = purchaseBill.organizationId;
            this.createTime = purchaseBill.createTime;
            this.updateTime = purchaseBill.updateTime;
            this.purchaseBillCode = purchaseBill.purchaseBillCode;
            this.saleOrchardId = purchaseBill.saleOrchardId;
            this.title = purchaseBill.title;
            this.orchardAddress = purchaseBill.orchardAddress;
            this.longitude = purchaseBill.longitude;
            this.latitude = purchaseBill.latitude;
            this.buyerId = purchaseBill.buyerId;
            this.buyerName = purchaseBill.buyerName;
            this.buyerType = purchaseBill.buyerType;
            this.sellerId = purchaseBill.sellerId;
            this.sellerName = purchaseBill.sellerName;
            this.sellerType = purchaseBill.sellerType;
            this.sellerArea = purchaseBill.sellerArea;
            this.sellerAreaRegion = purchaseBill.sellerAreaRegion;
            this.pickRequirement = purchaseBill.pickRequirement;
            this.requireSupplyDate = purchaseBill.requireSupplyDate;
            this.pickDate = purchaseBill.pickDate;
            this.ensureDate = purchaseBill.ensureDate;
            this.cancelDate = purchaseBill.cancelDate;
            this.rejectDate = purchaseBill.rejectDate;
            this.rejectReason = purchaseBill.rejectReason;
            this.depositDate = purchaseBill.depositDate;
            this.finalPaymentDate = purchaseBill.finalPaymentDate;
            this.amount = purchaseBill.amount;
            this.discount = purchaseBill.discount;
            this.deposit = purchaseBill.deposit;
            this.finalPayment = purchaseBill.finalPayment;
            this.supplyType = purchaseBill.supplyType;
            this.purchaseStatus = purchaseBill.purchaseStatus;
        }
    }
}
