package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 销售果园
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_sale_orchard")
public class SaleOrchard {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 销售果园Id
     */
    private String saleOrchardId;
    /**
     * 标题
     */
    private String title;
    /**
     * 销售果园图片
     */
    private String saleOrchardImage;
    /**
     * 果园地块编号
     */
    private String gardenCode;
    /**
     * 种植品种
     */
    private String plantType;
    /**
     * 果园地址
     */
    private String orchardAddress;
    /**
     * 地址经度
     */
    private BigDecimal longitude;
    /**
     * 地址纬度
     */
    private BigDecimal latitude;
    /**
     * 果园所属茶农Id
     */
    private String ownerId;
    /**
     * 果园所属茶农姓名
     */
    private String ownerName;
    /**
     * 地块数量
     */
    private Integer gardenCount;
    /**
     * 发布人Id
     */
    private String publisherId;
    /**
     * 发布人名
     */
    private String publisherName;
    /**
     * 销售果园Id 1茶农 4经纪人
     */
    private Integer publisherType;
    /**
     * 删除状态 1未删除 0已删除
     */
    private Integer deleteStatus;
    /**
     * 上下架状态 1已上架 0 下架
     */
    private Integer shelveStatus;
    /**
     * 果园面积
     */
    private BigDecimal gardenArea;

    public SaleOrchard(SaleOrchard saleOrchard) {
        if (Objects.nonNull(saleOrchard)) {
            this.id = saleOrchard.id;
            this.sysId = saleOrchard.sysId;
            this.organizationId = saleOrchard.organizationId;
            this.createTime = saleOrchard.createTime;
            this.updateTime = saleOrchard.updateTime;
            this.saleOrchardId = saleOrchard.saleOrchardId;
            this.title = saleOrchard.title;
            this.saleOrchardImage = saleOrchard.saleOrchardImage;
            this.gardenCode = saleOrchard.gardenCode;
            this.plantType = saleOrchard.plantType;
            this.orchardAddress = saleOrchard.orchardAddress;
            this.longitude = saleOrchard.longitude;
            this.latitude = saleOrchard.latitude;
            this.ownerId = saleOrchard.ownerId;
            this.ownerName = saleOrchard.ownerName;
            this.gardenCount = saleOrchard.gardenCount;
            this.publisherId = saleOrchard.publisherId;
            this.publisherName = saleOrchard.publisherName;
            this.publisherType = saleOrchard.publisherType;
            this.deleteStatus = saleOrchard.deleteStatus;
            this.shelveStatus = saleOrchard.shelveStatus;
            this.gardenArea = saleOrchard.gardenArea;
        }
    }
}
