package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 销售果园交易快照
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_sale_orchard_snapshot")
public class SaleOrchardSnapshot {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 销售果园Id
     */
    private String saleOrchardId;
    /**
     * 采购单单号
     */
    private String purchaseBillCode;
    /**
     * 销售果园图片
     */
    private String saleOrchardImage;
    /**
     * 种植品种
     */
    private String plantType;
    /**
     * 果园地址
     */
    private String orchardAddress;
    /**
     * 地址经度
     */
    private BigDecimal longitude;
    /**
     * 地址纬度
     */
    private BigDecimal latitude;
    /**
     * 果园所属茶农Id
     */
    private String ownerId;
    /**
     * 发布人Id
     */
    private String publisherId;
    /**
     * 销售果园Id 1茶农 4经纪人
     */
    private Integer publisherType;
    /**
     * 删除状态 1未删除 0已删除
     */
    private Integer deleteStatus;

    public SaleOrchardSnapshot(SaleOrchardSnapshot saleOrchardSnapshot) {
        if (Objects.nonNull(saleOrchardSnapshot)) {
            this.id = saleOrchardSnapshot.id;
            this.sysId = saleOrchardSnapshot.sysId;
            this.organizationId = saleOrchardSnapshot.organizationId;
            this.createTime = saleOrchardSnapshot.createTime;
            this.updateTime = saleOrchardSnapshot.updateTime;
            this.saleOrchardId = saleOrchardSnapshot.saleOrchardId;
            this.purchaseBillCode = saleOrchardSnapshot.purchaseBillCode;
            this.saleOrchardImage = saleOrchardSnapshot.saleOrchardImage;
            this.plantType = saleOrchardSnapshot.plantType;
            this.orchardAddress = saleOrchardSnapshot.orchardAddress;
            this.longitude = saleOrchardSnapshot.longitude;
            this.latitude = saleOrchardSnapshot.latitude;
            this.ownerId = saleOrchardSnapshot.ownerId;
            this.publisherId = saleOrchardSnapshot.publisherId;
            this.publisherType = saleOrchardSnapshot.publisherType;
            this.deleteStatus = saleOrchardSnapshot.deleteStatus;
        }
    }
}
