package com.panda.zgqc.app.utils;


import com.google.zxing.*;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Hashtable;
public class QRCodeUtil {
    private static final String CHARSET = "utf-8";
    // LOGO宽度
    private static final int WIDTH = 300;
    // LOGO高度
    private static final int HEIGHT = 300;
    // 图片的格式
    private  static  final  String  FORMAT = "png";
    // 图片边距
    private  static  final  int MARGIN = 2;

//    @GetMapping("/getQRCode/{userId}")
//    public void getQrcode(@PathVariable("userId") Long userId, HttpServletResponse response) throws Exception {
//
//        // 传参：二维码内容和生成路径
//        if (orCode("https://blog.csdn.net/q15102780705/article/details/100060137", "D:\\test\\images\\OR1.jpeg")){
//            System.out.println("ok,成功");
//        } else{
//            System.out.println("no,失败");
//        }
//    }

    /**
     * 生成二维码
     * @param content  二维码扫码之后跳转的页面地址
     * @param path   存储地址  本地就写本地  远端就写远端的
     * @return
     */
    private boolean orCode(String content, String path) {
        // 定义二维码的参数
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        // 定义字符集编码格式
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        // 纠错的等级 L > M > Q > H 纠错的能力越高可存储的越少，一般使用M
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        // 设置图片边距
        hints.put(EncodeHintType.MARGIN, MARGIN);

        try {
            // 最终生成 参数列表 （1.内容 2.格式 3.宽度 4.高度 5.二维码参数）
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, WIDTH, HEIGHT, hints);
//            // 写入到本地 （测试）
            Path file = new File(path).toPath();
            //todo  需要上传到云存储
            MatrixToImageWriter.writeToPath(bitMatrix, FORMAT, file);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

}
