package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.AgentFarmerRelevance;
import com.panda.zgqc.app.service.IAgentFarmerRelevanceService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/agenfarmer/relevance")
public class AgentFarmerRelevanceController {
    @Autowired
    private IAgentFarmerRelevanceService AgentFarmerRelevanceService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, AgentFarmerRelevance AgentFarmerRelevance) {
        return AjaxResult.success(AgentFarmerRelevanceService.page(pageEntity.toPage(), Wrappers.lambdaQuery(AgentFarmerRelevance)));
    }

    @GetMapping("/list")
    public AjaxResult list(AgentFarmerRelevance AgentFarmerRelevance) {

        return AjaxResult.success(AgentFarmerRelevanceService.list(Wrappers.lambdaQuery(AgentFarmerRelevance)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody AgentFarmerRelevance AgentFarmerRelevance) {
        return AjaxResult.success(AgentFarmerRelevanceService.save(AgentFarmerRelevance));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody AgentFarmerRelevance AgentFarmerRelevance) {
        return AjaxResult.success(AgentFarmerRelevanceService.updateById(AgentFarmerRelevance));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(AgentFarmerRelevanceService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(AgentFarmerRelevanceService.getById(id));
    }
}
