package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.BrandPackageApplyDetail;
import com.panda.zgqc.app.service.IBrandPackageApplyDetailService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/brand/package/apply/detail")
public class BrandPackageApplyDetailController {
    @Autowired
    private IBrandPackageApplyDetailService brandPackageApplyDetailService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, BrandPackageApplyDetail brandPackageApplyDetail) {
        return AjaxResult.success(brandPackageApplyDetailService.page(pageEntity.toPage(), Wrappers.lambdaQuery(brandPackageApplyDetail)));
    }

    @GetMapping("/list")
    public AjaxResult list(BrandPackageApplyDetail brandPackageApplyDetail) {
        return AjaxResult.success(brandPackageApplyDetailService.list(Wrappers.lambdaQuery(brandPackageApplyDetail)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody BrandPackageApplyDetail brandPackageApplyDetail) {
        return AjaxResult.success(brandPackageApplyDetailService.save(brandPackageApplyDetail));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody BrandPackageApplyDetail brandPackageApplyDetail) {
        return AjaxResult.success(brandPackageApplyDetailService.updateById(brandPackageApplyDetail));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(brandPackageApplyDetailService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(brandPackageApplyDetailService.getById(id));
    }
}
