package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.BrandPackage;
import com.panda.zgqc.app.service.IBrandPackageService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/brand/package")
public class BrandPackageController {
    @Autowired
    private IBrandPackageService brandPackageService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, BrandPackage brandPackage) {
        return AjaxResult.success(brandPackageService.page(pageEntity.toPage(), Wrappers.lambdaQuery(brandPackage)));
    }

    @GetMapping("/list")
    public AjaxResult list(BrandPackage brandPackage) {
        return AjaxResult.success(brandPackageService.list(Wrappers.lambdaQuery(brandPackage)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody BrandPackage brandPackage) {
        return AjaxResult.success(brandPackageService.save(brandPackage));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody BrandPackage brandPackage) {
        return AjaxResult.success(brandPackageService.updateById(brandPackage));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(brandPackageService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(brandPackageService.getById(id));
    }
}
