package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.DiseasePesoutline;
import com.panda.zgqc.app.service.IDiseasePesoutlineService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/disease/pesoutline")
public class DiseasePesoutlineController {
    @Autowired
    private IDiseasePesoutlineService diseasePesoutlineService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, DiseasePesoutline diseasePesoutline) {
        return AjaxResult.success(diseasePesoutlineService.page(pageEntity.toPage(), Wrappers.lambdaQuery(diseasePesoutline)));
    }

    @GetMapping("/list")
    public AjaxResult list(DiseasePesoutline diseasePesoutline) {
        return AjaxResult.success(diseasePesoutlineService.list(Wrappers.lambdaQuery(diseasePesoutline)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody DiseasePesoutline diseasePesoutline) {
        return AjaxResult.success(diseasePesoutlineService.save(diseasePesoutline));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody DiseasePesoutline diseasePesoutline) {
        return AjaxResult.success(diseasePesoutlineService.updateById(diseasePesoutline));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(diseasePesoutlineService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(diseasePesoutlineService.getById(id));
    }
}
