package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Iowarning;
import com.panda.zgqc.app.service.IIowarningService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/iowarning")
public class IowarningController {
    @Autowired
    private IIowarningService iowarningService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Iowarning iowarning) {
        return AjaxResult.success(iowarningService.page(pageEntity.toPage(), Wrappers.lambdaQuery(iowarning)));
    }

    @GetMapping("/list")
    public AjaxResult list(Iowarning iowarning) {
        return AjaxResult.success(iowarningService.list(Wrappers.lambdaQuery(iowarning)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Iowarning iowarning) {
        return AjaxResult.success(iowarningService.save(iowarning));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Iowarning iowarning) {
        return AjaxResult.success(iowarningService.updateById(iowarning));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(iowarningService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(iowarningService.getById(id));
    }
}
