package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.LaborHireEnroll;
import com.panda.zgqc.app.service.ILaborHireEnrollService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/labor/hire/enroll")
public class LaborHireEnrollController {
    @Autowired
    private ILaborHireEnrollService laborHireEnrollService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, LaborHireEnroll laborHireEnroll) {
        return AjaxResult.success(laborHireEnrollService.page(pageEntity.toPage(), Wrappers.lambdaQuery(laborHireEnroll)));
    }

    @GetMapping("/list")
    public AjaxResult list(LaborHireEnroll laborHireEnroll) {
        return AjaxResult.success(laborHireEnrollService.list(Wrappers.lambdaQuery(laborHireEnroll)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody LaborHireEnroll laborHireEnroll) {
        return AjaxResult.success(laborHireEnrollService.save(laborHireEnroll));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody LaborHireEnroll laborHireEnroll) {
        return AjaxResult.success(laborHireEnrollService.updateById(laborHireEnroll));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(laborHireEnrollService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(laborHireEnrollService.getById(id));
    }
}
