package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.LaborHireInfo;
import com.panda.zgqc.app.service.ILaborHireInfoService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/labor/hire/info")
public class LaborHireInfoController {
    @Autowired
    private ILaborHireInfoService laborHireInfoService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, LaborHireInfo laborHireInfo) {
        return AjaxResult.success(laborHireInfoService.page(pageEntity.toPage(), Wrappers.lambdaQuery(laborHireInfo)));
    }

    @GetMapping("/list")
    public AjaxResult list(LaborHireInfo laborHireInfo) {
        return AjaxResult.success(laborHireInfoService.list(Wrappers.lambdaQuery(laborHireInfo)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody LaborHireInfo laborHireInfo) {
        return AjaxResult.success(laborHireInfoService.save(laborHireInfo));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody LaborHireInfo laborHireInfo) {
        return AjaxResult.success(laborHireInfoService.updateById(laborHireInfo));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(laborHireInfoService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(laborHireInfoService.getById(id));
    }
}
