package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.LikeRelationship;
import com.panda.zgqc.app.service.ILikeRelationshipService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/like/relationship")
public class LikeRelationshipController {
    @Autowired
    private ILikeRelationshipService likeRelationshipService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, LikeRelationship likeRelationship) {
        return AjaxResult.success(likeRelationshipService.page(pageEntity.toPage(), Wrappers.lambdaQuery(likeRelationship)));
    }

    @GetMapping("/list")
    public AjaxResult list(LikeRelationship likeRelationship) {
        return AjaxResult.success(likeRelationshipService.list(Wrappers.lambdaQuery(likeRelationship)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody LikeRelationship likeRelationship) {
        return AjaxResult.success(likeRelationshipService.save(likeRelationship));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody LikeRelationship likeRelationship) {
        return AjaxResult.success(likeRelationshipService.updateById(likeRelationship));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(likeRelationshipService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(likeRelationshipService.getById(id));
    }
}
