package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.Markeentity;
import com.panda.zgqc.app.service.IMarkeentityService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/markeentity")
public class MarkeentityController {
    @Autowired
    private IMarkeentityService markeentityService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, Markeentity markeentity) {
        return AjaxResult.success(markeentityService.page(pageEntity.toPage(), Wrappers.lambdaQuery(markeentity)));
    }

    @GetMapping("/list")
    public AjaxResult list(Markeentity markeentity) {
        return AjaxResult.success(markeentityService.list(Wrappers.lambdaQuery(markeentity)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody Markeentity markeentity) {
        return AjaxResult.success(markeentityService.save(markeentity));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody Markeentity markeentity) {
        return AjaxResult.success(markeentityService.updateById(markeentity));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(markeentityService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(markeentityService.getById(id));
    }
}
